/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReason;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import java.util.HashSet;
import java.util.List;

public class LanguageProviderMismatch
extends KnownCrashReason {
    public LanguageProviderMismatch() {
        super(new HashSet<LogType>(){
            {
                this.add(LogType.LOG);
                this.add(LogType.CRASH_REPORT);
            }
        }, LanguageProvider.get((String)"warnings.language_provider_mismatch"), new String[0]);
    }

    @Override
    public boolean matches(Log log) {
        if (CrashAssistantApp.gameLaunchedSuccessfully) {
            return false;
        }
        if (!PlatformHelp.isForgeBased()) {
            return false;
        }
        List<String> lines = log.getReader().getAllLinesList();
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (!line.contains("Mod File ") || !line.contains(" needs language provider")) continue;
            Object errorLine = line;
            if (i + 1 < lines.size() && lines.get(i + 1).contains("We have found")) {
                errorLine = (String)errorLine + "\n" + lines.get(i + 1);
            }
            this.message = this.message.replace("$LINE_FROM_LOG$", (CharSequence)errorLine);
            return true;
        }
        return false;
    }
}

